/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.masterfs.filebasedfs.fileobjects;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.BaseFileObj;
import org.netbeans.modules.masterfs.filebasedfs.utils.FileChangedManager;
import org.netbeans.modules.masterfs.filebasedfs.utils.Utils;
import org.openide.filesystems.FileAlreadyLockedException;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

public class LockForFile
extends FileLock {
    private static final ConcurrentHashMap<String, Namesakes> name2Namesakes = new ConcurrentHashMap();
    private static final String PREFIX = ".LCK";
    private static final String SUFFIX = "~";
    private static final Logger LOGGER = Logger.getLogger(LockForFile.class.getName());
    private File file;
    private File lock;
    private boolean valid = false;

    private LockForFile(File file) {
        this.file = file;
        this.lock = LockForFile.getLockFile(file);
    }

    public static LockForFile findValid(File file) {
        Namesakes namesakes = name2Namesakes.get(file.getName());
        return namesakes != null ? namesakes.getInstance(file) : null;
    }

    public static LockForFile tryLock(File file) throws IOException {
        LockForFile lockForFile = new LockForFile(file);
        return LockForFile.registerLock(lockForFile);
    }

    private static LockForFile registerLock(LockForFile lockForFile) throws IOException, FileAlreadyLockedException {
        File file = lockForFile.getFile();
        Namesakes namesakes = new Namesakes();
        Namesakes namesakes2 = name2Namesakes.putIfAbsent(file.getName(), namesakes);
        if (namesakes2 != null) {
            namesakes = namesakes2;
        }
        if (namesakes.putInstance(file, lockForFile) == null) {
            FileAlreadyLockedException fileAlreadyLockedException = new FileAlreadyLockedException(file.getAbsolutePath());
            LockForFile lockForFile2 = namesakes.getInstance(file);
            if (lockForFile2 != null) {
                fileAlreadyLockedException.initCause(lockForFile2.lockedBy);
            }
            throw fileAlreadyLockedException;
        }
        lockForFile.valid = true;
        return lockForFile;
    }

    public static void relock(File file, File file2) {
        if (file2.isDirectory()) {
            Collection<Namesakes> collection = name2Namesakes.values();
            for (Namesakes namesakes : collection) {
                Collection collection2 = namesakes.values();
                for (Reference reference : collection2) {
                    File file3;
                    String string;
                    LockForFile lockForFile = (LockForFile)((Object)reference.get());
                    if (lockForFile == null || (string = Utils.getRelativePath(file, file3 = lockForFile.getFile())) == null) continue;
                    lockForFile.relock(new File(file2, string));
                }
            }
        } else {
            LockForFile lockForFile = LockForFile.findValid(file);
            if (lockForFile != null) {
                lockForFile.relock(file2);
            }
        }
    }

    private static synchronized void deregisterLock(LockForFile lockForFile) {
        if (lockForFile.isValid()) {
            File file;
            Namesakes namesakes;
            if (lockForFile.isHardLocked()) {
                lockForFile.hardUnlock();
            }
            if ((namesakes = name2Namesakes.get((file = lockForFile.getFile()).getName())) != null) {
                namesakes.remove(file);
                if (namesakes.isEmpty()) {
                    name2Namesakes.remove(file.getName());
                }
            }
        }
    }

    private void relock(File file) {
        try {
            LockForFile.deregisterLock(this);
            this.file = file;
            this.lock = LockForFile.getLockFile(file);
            LockForFile.registerLock(this);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hardLock() throws IOException {
        if (this.isHardLocked()) {
            throw new FileAlreadyLockedException(this.file.getAbsolutePath());
        }
        File file = this.getLock();
        file.getParentFile().mkdirs();
        file.createNewFile();
        try (OutputStream outputStream = Files.newOutputStream(file.toPath(), new OpenOption[0]);){
            outputStream.write(this.getFile().getAbsolutePath().getBytes());
            boolean bl = true;
            return bl;
        }
    }

    boolean hardUnlock() {
        return this.getLock().delete();
    }

    private static synchronized boolean hardUnlockAll() {
        boolean bl = true;
        Collection<Namesakes> collection = name2Namesakes.values();
        for (Namesakes namesakes : collection) {
            Collection collection2 = namesakes.values();
            for (Reference reference : collection2) {
                LockForFile lockForFile;
                if (reference == null || !(lockForFile = (LockForFile)((Object)reference.get())).isHardLocked() || lockForFile.hardUnlock()) continue;
                bl = false;
            }
        }
        return bl;
    }

    public File getLock() {
        return this.lock;
    }

    public File getFile() {
        return this.file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getHardLock() {
        if (FileChangedManager.getInstance().exists(this.lock)) {
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(this.lock);
                byte[] byArray = new byte[((InputStream)fileInputStream).available()];
                if (byArray.length > 0 && ((InputStream)fileInputStream).read(byArray) == byArray.length) {
                    File file = new File(new String(byArray));
                    return file;
                }
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
            finally {
                if (fileInputStream != null) {
                    try {
                        ((InputStream)fileInputStream).close();
                    }
                    catch (IOException iOException) {
                        Exceptions.printStackTrace((Throwable)iOException);
                    }
                }
            }
        }
        return null;
    }

    public boolean isHardLocked() {
        File file = this.getHardLock();
        return file != null ? LockForFile.findValid(file) != null : false;
    }

    public void rename() {
    }

    public static File getLockFile(File file) {
        file = FileUtil.normalizeFile((File)file);
        File file2 = file.getParentFile();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(PREFIX);
        stringBuilder.append(file.getName());
        stringBuilder.append(SUFFIX);
        String string = stringBuilder.toString();
        File file3 = new File(file2, string);
        return file3;
    }

    public boolean isValid() {
        Namesakes namesakes = name2Namesakes.get(this.file.getName());
        Reference reference = namesakes != null ? (Reference)namesakes.get(this.file) : null;
        return reference != null && super.isValid() && this.valid;
    }

    public void releaseLock() {
        this.releaseLock(true);
    }

    final void releaseLock(boolean bl) {
        FileObject fileObject;
        LockForFile.deregisterLock(this);
        super.releaseLock();
        if (bl && (fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)this.file))) instanceof BaseFileObj) {
            ((BaseFileObj)fileObject).getProvidedExtensions().fileUnlocked(fileObject);
        }
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                LockForFile.hardUnlockAll();
            }
        });
    }

    private static class Namesakes
    extends ConcurrentHashMap<File, Reference<LockForFile>> {
        private Namesakes() {
        }

        private LockForFile getInstance(File file) {
            Reference reference = (Reference)this.get(file);
            return reference != null ? (LockForFile)((Object)reference.get()) : null;
        }

        private LockForFile putInstance(File file, LockForFile lockForFile) throws IOException {
            Reference reference;
            if (!this.isEmpty() && LockForFile.findValid(lockForFile.getFile()) == null) {
                this.hardLock();
                lockForFile.hardLock();
            }
            return (reference = (Reference)this.putIfAbsent(file, new WeakReference<LockForFile>(lockForFile))) != null ? null : lockForFile;
        }

        private void hardLock() throws IOException {
            Collection collection = this.values();
            for (Reference reference : collection) {
                LockForFile lockForFile;
                if (reference == null || (lockForFile = (LockForFile)((Object)reference.get())) == null || FileChangedManager.getInstance().exists(lockForFile.getLock())) continue;
                lockForFile.hardLock();
            }
        }
    }
}

