/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.argon2.algorithm;

import net.sourceforge.plantuml.argon2.Util;
import net.sourceforge.plantuml.argon2.blake2.Blake2b;
import net.sourceforge.plantuml.argon2.model.Block;

class Functions {
    Functions() {
    }

    static byte[] initialHash(byte[] lanes, byte[] outputLength, byte[] memory, byte[] iterations, byte[] version, byte[] type, byte[] passwordLength, byte[] password, byte[] saltLength, byte[] salt, byte[] secretLength, byte[] secret, byte[] additionalLength, byte[] additional) {
        Blake2b.Param params = new Blake2b.Param().setDigestLength(64);
        Blake2b.Digest blake2b = Blake2b.Digest.newInstance(params);
        blake2b.update(lanes);
        blake2b.update(outputLength);
        blake2b.update(memory);
        blake2b.update(iterations);
        blake2b.update(version);
        blake2b.update(type);
        blake2b.update(passwordLength);
        if (password != null) {
            blake2b.update(password);
        }
        blake2b.update(saltLength);
        if (salt != null) {
            blake2b.update(salt);
        }
        blake2b.update(secretLength);
        if (secret != null) {
            blake2b.update(secret);
        }
        blake2b.update(additionalLength);
        if (additional != null) {
            blake2b.update(additional);
        }
        byte[] blake2hash = blake2b.digest();
        assert (blake2hash.length == 64);
        return blake2hash;
    }

    static byte[] blake2bLong(byte[] input, int outputLength) {
        assert (input.length == 72 || input.length == 1024);
        byte[] result = new byte[outputLength];
        byte[] outlenBytes = Util.intToLittleEndianBytes(outputLength);
        int blake2bLength = 64;
        if (outputLength <= blake2bLength) {
            result = Functions.blake2b(input, outlenBytes, outputLength);
        } else {
            byte[] outBuffer = Functions.blake2b(input, outlenBytes, blake2bLength);
            System.arraycopy(outBuffer, 0, result, 0, blake2bLength / 2);
            int r = outputLength / 32 + (outputLength % 32 == 0 ? 0 : 1) - 2;
            int position = blake2bLength / 2;
            int i = 2;
            while (i <= r) {
                outBuffer = Functions.blake2b(outBuffer, null, blake2bLength);
                System.arraycopy(outBuffer, 0, result, position, blake2bLength / 2);
                ++i;
                position += blake2bLength / 2;
            }
            int lastLength = outputLength - 32 * r;
            outBuffer = Functions.blake2b(outBuffer, null, lastLength);
            System.arraycopy(outBuffer, 0, result, position, lastLength);
        }
        assert (result.length == outputLength);
        return result;
    }

    private static byte[] blake2b(byte[] input, byte[] outlenBytes, int outputLength) {
        Blake2b.Param params = new Blake2b.Param().setDigestLength(outputLength);
        Blake2b.Digest blake2b = Blake2b.Digest.newInstance(params);
        if (outlenBytes != null) {
            blake2b.update(outlenBytes);
        }
        blake2b.update(input);
        return blake2b.digest();
    }

    static void roundFunction(Block block, int v0, int v1, int v2, int v3, int v4, int v5, int v6, int v7, int v8, int v9, int v10, int v11, int v12, int v13, int v14, int v15) {
        Functions.F(block, v0, v4, v8, v12);
        Functions.F(block, v1, v5, v9, v13);
        Functions.F(block, v2, v6, v10, v14);
        Functions.F(block, v3, v7, v11, v15);
        Functions.F(block, v0, v5, v10, v15);
        Functions.F(block, v1, v6, v11, v12);
        Functions.F(block, v2, v7, v8, v13);
        Functions.F(block, v3, v4, v9, v14);
    }

    private static void F(Block block, int a, int b, int c, int d) {
        Functions.fBlaMka(block, a, b);
        Functions.rotr64(block, d, a, 32L);
        Functions.fBlaMka(block, c, d);
        Functions.rotr64(block, b, c, 24L);
        Functions.fBlaMka(block, a, b);
        Functions.rotr64(block, d, a, 16L);
        Functions.fBlaMka(block, c, d);
        Functions.rotr64(block, b, c, 63L);
    }

    private static void fBlaMka(Block block, int x, int y) {
        long m = 0xFFFFFFFFL;
        long xy = (block.v[x] & 0xFFFFFFFFL) * (block.v[y] & 0xFFFFFFFFL);
        block.v[x] = block.v[x] + block.v[y] + 2L * xy;
    }

    private static void rotr64(Block block, int v, int w, long c) {
        long temp = block.v[v] ^ block.v[w];
        block.v[v] = temp >>> (int)c | temp << (int)(64L - c);
    }
}

