/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import org.apache.lucene.index.DocumentsWriterFlushControl;
import org.apache.lucene.index.DocumentsWriterPerThread;
import org.apache.lucene.index.FlushPolicy;

class FlushByRamOrCountsPolicy
extends FlushPolicy {
    FlushByRamOrCountsPolicy() {
    }

    @Override
    public void onChange(DocumentsWriterFlushControl control, DocumentsWriterPerThread perThread) {
        if (perThread != null && this.flushOnDocCount() && perThread.getNumDocsInRAM() >= this.indexWriterConfig.getMaxBufferedDocs()) {
            control.setFlushPending(perThread);
        } else if (this.flushOnRAM()) {
            long limit = (long)(this.indexWriterConfig.getRAMBufferSizeMB() * 1024.0 * 1024.0);
            long activeRam = control.activeBytes();
            long deletesRam = control.getDeleteBytesUsed();
            if (deletesRam >= limit && activeRam >= limit && perThread != null) {
                this.flushDeletes(control);
                this.flushActiveBytes(control, perThread);
            } else if (deletesRam >= limit) {
                this.flushDeletes(control);
            } else if (activeRam + deletesRam >= limit && perThread != null) {
                this.flushActiveBytes(control, perThread);
            }
        }
    }

    private void flushDeletes(DocumentsWriterFlushControl control) {
        control.setApplyAllDeletes();
        if (this.infoStream.isEnabled("FP")) {
            this.infoStream.message("FP", "force apply deletes bytesUsed=" + control.getDeleteBytesUsed() + " vs ramBufferMB=" + this.indexWriterConfig.getRAMBufferSizeMB());
        }
    }

    private void flushActiveBytes(DocumentsWriterFlushControl control, DocumentsWriterPerThread perThread) {
        if (this.infoStream.isEnabled("FP")) {
            this.infoStream.message("FP", "trigger flush: activeBytes=" + control.activeBytes() + " deleteBytes=" + control.getDeleteBytesUsed() + " vs ramBufferMB=" + this.indexWriterConfig.getRAMBufferSizeMB());
        }
        this.markLargestWriterPending(control, perThread);
    }

    protected void markLargestWriterPending(DocumentsWriterFlushControl control, DocumentsWriterPerThread perThread) {
        DocumentsWriterPerThread largestNonPendingWriter = this.findLargestNonPendingWriter(control, perThread);
        if (largestNonPendingWriter != null) {
            control.setFlushPending(largestNonPendingWriter);
        }
    }

    protected boolean flushOnDocCount() {
        return this.indexWriterConfig.getMaxBufferedDocs() != -1;
    }

    protected boolean flushOnRAM() {
        return this.indexWriterConfig.getRAMBufferSizeMB() != -1.0;
    }
}

