/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.impl;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Iterator;
import java.util.Map;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.DirectedSubgraph;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Element;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.GraphView;
import org.gephi.graph.api.Node;
import org.gephi.graph.impl.ColumnImpl;
import org.gephi.graph.impl.ColumnStore;
import org.gephi.graph.impl.ElementImpl;
import org.gephi.graph.impl.GraphViewImpl;
import org.gephi.graph.impl.IndexImpl;
import org.gephi.graph.impl.TableLockImpl;

public class IndexStore<T extends Element> {
    protected final ColumnStore<T> columnStore;
    protected final TableLockImpl lock;
    protected final IndexImpl<T> mainIndex;
    protected final Map<GraphView, IndexImpl<T>> viewIndexes;

    public IndexStore(ColumnStore<T> columnStore) {
        this.columnStore = columnStore;
        this.mainIndex = new IndexImpl<T>(columnStore);
        this.viewIndexes = new Object2ObjectOpenHashMap();
        this.lock = columnStore.lock;
    }

    protected void addColumn(ColumnImpl col) {
        this.mainIndex.addColumn(col);
        for (IndexImpl<T> index : this.viewIndexes.values()) {
            index.addColumn(col);
        }
    }

    protected void removeColumn(ColumnImpl col) {
        this.mainIndex.removeColumn(col);
        for (IndexImpl<T> index : this.viewIndexes.values()) {
            index.removeColumn(col);
        }
    }

    protected boolean hasColumn(ColumnImpl col) {
        return this.mainIndex.hasColumn(col);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IndexImpl getIndex(Graph graph) {
        GraphView view = graph.getView();
        if (view.isMainView()) {
            return this.mainIndex;
        }
        Map<GraphView, IndexImpl<T>> map = this.viewIndexes;
        synchronized (map) {
            IndexImpl viewIndex = this.viewIndexes.get(graph.getView());
            if (viewIndex == null) {
                viewIndex = this.createViewIndex(graph);
            }
            return viewIndex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IndexImpl createViewIndex(Graph graph) {
        if (graph.getView().isMainView()) {
            throw new IllegalArgumentException("Can't create a view index for the main view");
        }
        this.lock();
        try {
            IndexImpl<T> viewIndex = new IndexImpl<T>(this.columnStore, graph);
            ColumnImpl[] columns = this.columnStore.toArray();
            viewIndex.addAllColumns(columns);
            this.viewIndexes.put(graph.getView(), viewIndex);
            this.indexView(graph);
            IndexImpl<T> indexImpl = viewIndex;
            return indexImpl;
        }
        finally {
            this.unlock();
        }
    }

    protected void deleteViewIndex(Graph graph) {
        if (graph.getView().isMainView()) {
            throw new IllegalArgumentException("Can't delete a view index for the main view");
        }
        this.lock();
        try {
            IndexImpl<T> index = this.viewIndexes.remove(graph.getView());
            if (index != null) {
                index.destroy();
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object set(Column column, Object oldValue, Object value, T element) {
        value = this.mainIndex.set(column, oldValue, value, element);
        if (!this.viewIndexes.isEmpty()) {
            Map<GraphView, IndexImpl<T>> map = this.viewIndexes;
            synchronized (map) {
                for (Map.Entry<GraphView, IndexImpl<T>> entry : this.viewIndexes.entrySet()) {
                    GraphViewImpl graphView = (GraphViewImpl)entry.getKey();
                    DirectedSubgraph graph = graphView.getDirectedGraph();
                    boolean inView = element instanceof Node ? graph.contains((Node)element) : graph.contains((Edge)element);
                    if (!inView) continue;
                    entry.getValue().set(column, oldValue, value, element);
                }
            }
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear(T element) {
        ElementImpl elementImpl = (ElementImpl)element;
        this.lock();
        try {
            int length = this.columnStore.length;
            ColumnImpl[] cols = this.columnStore.columns;
            for (int i = 0; i < length; ++i) {
                ColumnImpl c = cols[i];
                if (c == null || !c.isIndexed()) continue;
                Object value = elementImpl.getAttribute(c);
                this.mainIndex.remove(c, value, element);
                if (this.viewIndexes.isEmpty()) continue;
                Map<GraphView, IndexImpl<T>> map = this.viewIndexes;
                synchronized (map) {
                    for (Map.Entry<GraphView, IndexImpl<T>> entry : this.viewIndexes.entrySet()) {
                        GraphViewImpl graphView = (GraphViewImpl)entry.getKey();
                        DirectedSubgraph graph = graphView.getDirectedGraph();
                        boolean inView = element instanceof Node ? graph.contains((Node)element) : graph.contains((Edge)element);
                        if (!inView) continue;
                        entry.getValue().remove(c, value, element);
                    }
                    continue;
                }
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void index(T element) {
        ElementImpl elementImpl = (ElementImpl)element;
        this.lock();
        try {
            int length = this.columnStore.length;
            ColumnImpl[] cols = this.columnStore.columns;
            for (int i = 0; i < length; ++i) {
                ColumnImpl c = cols[i];
                if (c == null || !c.isIndexed()) continue;
                Object value = elementImpl.getAttribute(c);
                value = this.mainIndex.put(c, value, element);
                elementImpl.attributes.setAttribute(c, value);
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void indexView(Graph graph) {
        IndexImpl<ElementImpl> viewIndex = this.viewIndexes.get(graph.getView());
        if (viewIndex != null) {
            graph.readLock();
            try {
                Iterator<Element> iterator = null;
                if (this.columnStore.elementType.equals(Node.class)) {
                    iterator = graph.getNodes().iterator();
                } else if (this.columnStore.elementType.equals(Edge.class)) {
                    iterator = graph.getEdges().iterator();
                }
                if (iterator != null) {
                    while (iterator.hasNext()) {
                        ElementImpl element = (ElementImpl)iterator.next();
                        ColumnImpl[] cols = this.columnStore.columns;
                        int length = this.columnStore.length;
                        for (int i = 0; i < length; ++i) {
                            ColumnImpl c = cols[i];
                            if (c == null || !c.isIndexed()) continue;
                            Object value = element.getAttribute(c);
                            viewIndex.put(c, value, element);
                        }
                    }
                }
            }
            finally {
                graph.readUnlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void indexInView(T element, GraphView view) {
        ElementImpl elementImpl = (ElementImpl)element;
        this.lock();
        try {
            IndexImpl<T> index = this.viewIndexes.get(view);
            if (index != null) {
                int length = this.columnStore.length;
                ColumnImpl[] cols = this.columnStore.columns;
                for (int i = 0; i < length; ++i) {
                    ColumnImpl c = cols[i];
                    if (c == null || !c.isIndexed()) continue;
                    Object value = elementImpl.getAttribute(c);
                    index.put(c, value, element);
                }
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearInView(T element, GraphView view) {
        ElementImpl elementImpl = (ElementImpl)element;
        this.lock();
        try {
            IndexImpl<T> index = this.viewIndexes.get(view);
            if (index != null) {
                int length = this.columnStore.length;
                ColumnImpl[] cols = this.columnStore.columns;
                for (int i = 0; i < length; ++i) {
                    ColumnImpl c = cols[i];
                    if (c == null || !c.isIndexed()) continue;
                    Object value = elementImpl.getAttribute(c);
                    index.remove(c, value, element);
                }
            }
        }
        finally {
            this.unlock();
        }
    }

    public void clear(GraphView view) {
        this.lock();
        try {
            IndexImpl<T> index = this.viewIndexes.get(view);
            if (index != null) {
                index.clear();
            }
        }
        finally {
            this.unlock();
        }
    }

    public void clear() {
        this.lock();
        try {
            this.mainIndex.clear();
            for (IndexImpl<T> index : this.viewIndexes.values()) {
                index.clear();
            }
        }
        finally {
            this.unlock();
        }
    }

    private void lock() {
        if (this.lock != null) {
            this.lock.lock();
        }
    }

    private void unlock() {
        if (this.lock != null) {
            this.lock.unlock();
        }
    }
}

