/**
 * SECTION:debug
 * @short_description: Manages debug output and status reporting for all folks objects.
 * 
 * <para>All GLib debug logging calls are passed through a log handler in this class, which allows debug domains to be outputted according to whether they&apos;ve been enabled by being passed to <link linkend="folks-debug-dup"><function>folks_debug_dup()</function></link>.</para>
 *
 * Since: 0.5.1
 */
/**
 * FOLKS_TYPE_DEBUG:
 * 
 * The type for <link linkend="FolksDebug"><type>FolksDebug</type></link>.
 */
/**
 * folks_debug_emit_print_status:
 * @self: the <link linkend="FolksDebug"><type>FolksDebug</type></link> instance
 * 
 * Causes all significant objects in the library to print their current status to standard output, obeying the options set on this <link linkend="FolksDebug"><type>FolksDebug</type></link> instance for colouring and other formatting.
 *
 * Since: 0.5.1
 */
/**
 * folks_debug_indent:
 * @self: the <link linkend="FolksDebug"><type>FolksDebug</type></link> instance
 * 
 * Increment the indentation level used when printing output through the object.
 * 
 * <para>This is intended to be used by backend libraries only.</para>
 *
 * Since: 0.5.1
 */
/**
 * folks_debug_unindent:
 * @self: the <link linkend="FolksDebug"><type>FolksDebug</type></link> instance
 * 
 * Decrement the indentation level used when printing output through the object.
 * 
 * <para>This is intended to be used by backend libraries only.</para>
 *
 * Since: 0.5.1
 */
/**
 * folks_debug_print_line:
 * @...: (in): &nbsp;.  <para>Arguments for the format string </para>
 * @self: the <link linkend="FolksDebug"><type>FolksDebug</type></link> instance
 * @domain: (in): &nbsp;.  <para>The debug domain name </para>
 * @level: (in): &nbsp;.  <para>A set of log level flags for the message </para>
 * @format: (in): &nbsp;.  <para>A printf-style format string for the heading </para>
 * 
 * Print a debug line with the current indentation level for the specified debug domain.
 * 
 * <para>This is intended to be used by backend libraries only.</para>
 *
 * Since: 0.5.1
 */
/**
 * folks_debug_print_heading:
 * @...: (in): &nbsp;.  <para>Arguments for the format string </para>
 * @self: the <link linkend="FolksDebug"><type>FolksDebug</type></link> instance
 * @domain: (in): &nbsp;.  <para>The debug domain name </para>
 * @level: (in): &nbsp;.  <para>A set of log level flags for the message </para>
 * @format: (in): &nbsp;.  <para>A printf-style format string for the heading </para>
 * 
 * Print a debug line as a heading. It will be coloured according to the current indentation level so that different levels of headings stand out.
 * 
 * <para>This is intended to be used by backend libraries only.</para>
 *
 * Since: 0.5.1
 */
/**
 * folks_debug_print_key_value_pairs:
 * @...: (in): &nbsp;.  <para>Alternating keys and values, terminated with null </para>
 * @self: the <link linkend="FolksDebug"><type>FolksDebug</type></link> instance
 * @domain: (in): &nbsp;.  <para>The debug domain name </para>
 * @level: (in): &nbsp;.  <para>A set of log level flags for the message </para>
 * 
 * Print a set of key–value pairs in a table. The width of the key column is automatically set to the width of the longest key. The keys and values must be provided as a null-delimited list of alternating key–value varargs. Values may be null but keys may not.
 * 
 * <para>This is intended to be used by backend libraries only.</para><para>The table will be printed at the current indentation level plus one.</para>
 *
 * Since: 0.5.1
 */
/**
 * FOLKS_DEBUG_STATUS_LOG_DOMAIN:
 * 
 * Log domain for the status messages logged as a result of calling <link linkend="folks-debug-emit-print-status"><function>folks_debug_emit_print_status()</function></link>.
 * 
 * <para>This could be used in conjunction with a log handler to redirect the status information to a debug window or log file, for example.</para>
 *
 * Since: 0.5.1
 */
/**
 * FolksDebug:colour-enabled:
 */
/**
 * folks_debug_get_colour_enabled:
 * @self: the <link linkend="FolksDebug"><type>FolksDebug</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="FolksDebug--colour-enabled"><type>"colour-enabled"</type></link> property.
 * 
 * 
 * 
 * Returns: the value of the <link linkend="FolksDebug--colour-enabled"><type>"colour-enabled"</type></link> property
 */
/**
 * folks_debug_set_colour_enabled:
 * @self: the <link linkend="FolksDebug"><type>FolksDebug</type></link> instance to modify
 * @value: the new value of the <link linkend="FolksDebug--colour-enabled"><type>"colour-enabled"</type></link> property
 * 
 * Set the value of the <link linkend="FolksDebug--colour-enabled"><type>"colour-enabled"</type></link> property to @value.
 * 
 * 
 */
/**
 * FolksDebug:debug-output-enabled:
 * 
 * Whether debug output is enabled. This is orthogonal to the set of enabled debug domains; filtering of debug output as a whole is done after filtering by enabled domains.
 *
 * Since: 0.5.1
 */
/**
 * folks_debug_get_debug_output_enabled:
 * @self: the <link linkend="FolksDebug"><type>FolksDebug</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="FolksDebug--debug-output-enabled"><type>"debug-output-enabled"</type></link> property.
 * 
 * Whether debug output is enabled. This is orthogonal to the set of enabled debug domains; filtering of debug output as a whole is done after filtering by enabled domains.
 * 
 * Returns: the value of the <link linkend="FolksDebug--debug-output-enabled"><type>"debug-output-enabled"</type></link> property
 *
 * Since: 0.5.1
 */
/**
 * folks_debug_set_debug_output_enabled:
 * @self: the <link linkend="FolksDebug"><type>FolksDebug</type></link> instance to modify
 * @value: the new value of the <link linkend="FolksDebug--debug-output-enabled"><type>"debug-output-enabled"</type></link> property
 * 
 * Set the value of the <link linkend="FolksDebug--debug-output-enabled"><type>"debug-output-enabled"</type></link> property to @value.
 * 
 * Whether debug output is enabled. This is orthogonal to the set of enabled debug domains; filtering of debug output as a whole is done after filtering by enabled domains.
 *
 * Since: 0.5.1
 */
/**
 * FolksDebug::print-status:
 * @debug: the <link linkend="FolksDebug"><type>FolksDebug</type></link> instance that received the signal
 * 
 * Signal emitted in the main thread whenever objects should print their current status. All significant objects in the library should connect to this and print their current status in some suitable format when it&apos;s emitted.
 * 
 * <para>Client processes should emit this signal by calling <link linkend="folks-debug-emit-print-status"><function>folks_debug_emit_print_status()</function></link>.</para>
 *
 * Since: 0.5.1
 */
/**
 * folks_debug_dup:
 * 
 * Create or return the singleton <link linkend="FolksDebug"><type>FolksDebug</type></link> class instance. If the instance doesn&apos;t exist already, it will be created with no debug domains enabled.
 * 
 * <para>This function is thread-safe.</para>
 * 
 * Returns: <para>Singleton <link linkend="FolksDebug"><type>FolksDebug</type></link> instance </para>
 *
 * Since: 0.5.1
 */
/**
 * folks_debug_dup_with_flags:
 * @debug_flags: (in) (allow-none): &nbsp;.  <para>A comma-separated list of debug domains to enable, or null to disable debug output </para>
 * @colour_enabled: (in): &nbsp;.  <para>Whether debug output should be coloured using terminal escape sequences </para>
 * 
 * Create or return the singleton <link linkend="FolksDebug"><type>FolksDebug</type></link> class instance. If the instance doesn&apos;t exist already, it will be created with the given set of debug domains enabled. Otherwise, the existing instance will have its set of enabled domains changed to the provided set.
 * 
 * Returns: <para>Singleton <link linkend="FolksDebug"><type>FolksDebug</type></link> instance </para>
 *
 * Since: 0.5.1
 */
/**
 * FolksDebug:
 * 
 * Manages debug output and status reporting for all folks objects.
 * 
 * <para>All GLib debug logging calls are passed through a log handler in this class, which allows debug domains to be outputted according to whether they&apos;ve been enabled by being passed to <link linkend="folks-debug-dup"><function>folks_debug_dup()</function></link>.</para>
 *
 * Since: 0.5.1
 */
/**
 * FolksDebugClass:
 * @parent_class: the parent class structure
 * 
 * The class structure for <link linkend="FOLKS-TYPE-DEBUG:CAPS"><literal>FOLKS_TYPE_DEBUG</literal></link>. All the fields in this structure are private and should never be accessed directly.
 */
