#!/usr/bin/env python
#
# Copyright (C) 2023 Intel Corporation
#
# This software and the related documents are Intel copyrighted materials, and your use of them
# is governed by the express license under which they were provided to you ("License"). Unless
# the License provides otherwise, you may not use, modify, copy, publish, distribute, disclose
# or transmit this software or the related documents without Intel's prior written permission.
#
# This software and the related documents are provided as is, with no express or implied
# warranties, other than those that are expressly stated in the License.
#


from __future__ import print_function

import argparse
import os
import subprocess
import sys
import signal

TOOL_BINARY = 'usmtool'

def error(*args, **kwargs):
    print(*args, **kwargs, file=sys.stderr)

def log(*args, **kwargs):
    print(*args, **kwargs, file=sys.stdout)


def start_collection():
    print('Starting USM collection...')

    current_working_directory = os.getcwd()
    product_bin_path = os.path.abspath(os.path.dirname(__file__))

    tool_binary_name = [TOOL_BINARY]
    tool_binary_path = os.path.join(product_bin_path, TOOL_BINARY)
    cmd = [tool_binary_path,
           '-start']
    print(tool_binary_path)
    subprocess.Popen(cmd, stderr=subprocess.STDOUT)


def stop_collection():
    log('Stopping USM collection...')
    target_binary = TOOL_BINARY
    cmd = ['killall', '--wait', '--signal', 'SIGINT', target_binary]
#    cmd = ['killall', '--process-group', '--signal', 'SIGINT', target_binary]
    result = subprocess.run(cmd, stdout=subprocess.PIPE, stderr=subprocess.STDOUT)
    if result.returncode == 0:
        log('USM collection has been successfully stopped.')
    else:
        log('killall failed (', result.returncode, '): ', str(result.stdout, 'utf-8'))
        error('Failed to stop usm collection, please contact VTune Profiler team for support.')
        sys.exit(1)


def main():
    collect_cmd = os.getenv('AMPLXE_COLLECT_CMD')
    data_dir = os.getenv('AMPLXE_DATA_DIR')

    if collect_cmd == 'start':
        start_collection()
    elif collect_cmd == 'stop':
        stop_collection()
    else:
        print('The script should be executed as the custom collector.')
        sys.exit(1)


if __name__ == '__main__':
    # disable Ctrl-C signal
    signal.signal(signal.SIGINT, signal.SIG_IGN)
    main()
