#
# Copyright (C) 2021 Intel Corporation
#
# This software and the related documents are Intel copyrighted materials, and your use of them
# is governed by the express license under which they were provided to you ("License"). Unless
# the License provides otherwise, you may not use, modify, copy, publish, distribute, disclose
# or transmit this software or the related documents without Intel's prior written permission.
#
# This software and the related documents are provided as is, with no express or implied
# warranties, other than those that are expressly stated in the License.
#


# ------------------------------------------------------------------------------
# This example shows how to obtain information about kernels executed on CPU.
# Run characterisation analysis to gather the data then use the script
#
# The information is only available for loops in the topdown table.
#
# A CPU kernel info contains the following fields:
#
# - local_size: Kernel's local size
# - global_size: Kernel's global size
# - kernel_invocation_count: A number of times the kernel was invoked
# ------------------------------------------------------------------------------

import sys

try:

    import advisor

except ImportError:

    print(
        """Import error: Python could not resolve path to Advisor's pythonapi directory.
        To fix, either manually add path to the pythonapi directory into PYTHONPATH environment
        variable, or use advisor-vars.* scripts to set up product environment variables automatically."""
    )
    sys.exit(1)

# Check command-line arguments.
if len(sys.argv) < 2:
    print('Usage: "python {} path_to_project_dir [comma-separated-column-list]"'.format(__file__))
    sys.exit(2)

# Open the Advisor Project and load the data.
project = advisor.open_project(sys.argv[1])
data = project.load(advisor.SURVEY)

for row in data.topdown:
    stack = [row]
    while stack:
        v = stack.pop()
        # Print CPU kernel info if any
        for cpu_kernel_info in v.cpu_kernel_info:
            cpu_kernel_name_key = "function_call_sites_and_loops"
            print("{:_<45}: {}".format(cpu_kernel_name_key, v[cpu_kernel_name_key]))
            for key in cpu_kernel_info:
                print("{:_<45}: {}".format(key, cpu_kernel_info[key]))

        # Go deeper in Top Down tree
        for r in v.get_children():
            stack.append(r)


